<?php
session_start(); // Iniciar a sessão

// Incluir a conexão com o banco de dados
include('conexao.php');

// Definir as variáveis para o formulário
$username = $password = $role = $expiresAt = '';
$usernameErr = $passwordErr = $roleErr = $expiresAtErr = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validar nome de usuário
    if (empty($_POST["username"])) {
        $usernameErr = "Nome de usuário é obrigatório!";
    } else {
        $username = trim($_POST["username"]);
    }

    // Validar senha
    if (empty($_POST["password"])) {
        $passwordErr = "Senha é obrigatória!";
    } else {
        $password = $_POST["password"];
    }

    // Validar role (opcional)
    if (empty($_POST["role"])) {
        $role = 'admin'; // Definir 'admin' como valor padrão
    } else {
        $role = $_POST["role"];
    }

    // Validar a data de expiração (opcional)
    if (empty($_POST["expires_at"])) {
        $expiresAt = null; // Deixar vazio se não for fornecido
    } else {
        $expiresAt = $_POST["expires_at"];
    }

    // Se não houver erros de validação, inserir no banco
    if (empty($usernameErr) && empty($passwordErr) && empty($roleErr) && empty($expiresAtErr)) {
        // Hash da senha
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Inserir a data de criação
        $createdAt = date("Y-m-d H:i:s");

        // Preparar a consulta SQL para inserir o usuário
        $sql = "INSERT INTO users (username, password, role, created_at, expires_at) VALUES (?, ?, ?, ?, ?)";

        try {
            // Preparar a consulta
            $stmt = $pdo->prepare($sql);
            // Associar os valores aos parâmetros
            $stmt->execute([$username, $hashedPassword, $role, $createdAt, $expiresAt]);

            $_SESSION['message'] = "Usuário criado com sucesso!";
            header("Location: admin_users.php"); // Redirecionar para a página admin_users.php
            exit;
        } catch (PDOException $e) {
            $_SESSION['message'] = "Erro ao criar o usuário: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Criar Novo Usuário</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Vídeo de fundo */
        body, html {
            height: 100%;
            margin: 0;
            padding: 0;
            position: relative;
            font-family: Arial, sans-serif;
        }

        video.background-video {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: -1; /* Coloca o vídeo atrás do conteúdo */
        }

        .container {
            z-index: 1; /* Garante que o conteúdo fique na frente do vídeo */
            padding-top: 80px;
            max-width: 500px;
            background-color: rgba(0, 0, 0, 0.6); /* Fundo escuro para contraste */
            border-radius: 10px;
            padding: 30px;
            color: white;
        }

        .form-control, .btn {
            border-radius: 25px;
            padding: 12px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
        }

        .form-control {
            background-color: #444; /* Fundo cinza para os campos */
            color: white;
            border: none;
        }

        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 8px rgba(78, 115, 223, 0.6);
        }

        .btn-primary {
            background-color: #4e73df;
            border: none;
            transition: background-color 0.3s, transform 0.2s;
        }

        .btn-primary:hover {
            background-color: #2e59d9;
            transform: scale(1.05);
        }

        .btn-secondary {
            background-color: #e74a3b;
            border: none;
            transition: background-color 0.3s, transform 0.2s;
        }

        .btn-secondary:hover {
            background-color: #e44c3b;
            transform: scale(1.05);
        }

        h2 {
            color: white;
            text-align: center;
            font-weight: bold;
        }

        .form-label {
            color: white;
            font-weight: 600;
        }

        .text-danger {
            font-size: 0.9rem;
        }

        .alert {
            margin-top: 20px;
        }

        .btn-back {
            margin-top: 15px;
        }
    </style>
</head>
<body>

    <!-- Vídeo Plexus como fundo -->
    <video class="background-video" autoplay loop muted>
        <source src="Plexus.mp4" type="video/mp4">
        Seu navegador não suporta vídeos.
    </video>

    <div class="container">
        <h2>Criar Novo Usuário</h2>

        <?php if (isset($_SESSION['message'])): ?>
            <div class="alert alert-info" role="alert">
                <?= $_SESSION['message'] ?>
                <?php unset($_SESSION['message']); ?>
            </div>
        <?php endif; ?>

        <div class="card">
            <form action="create_user.php" method="POST">
                <div class="mb-3">
                    <label for="username" class="form-label">Nome de Usuário</label>
                    <input type="text" class="form-control" id="username" name="username" value="" required>
                    <span class="text-danger"><?= $usernameErr ?></span>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Senha</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                    <span class="text-danger"><?= $passwordErr ?></span>
                </div>

                <div class="mb-3">
                    <label for="role" class="form-label">Papel</label>
                    <select class="form-control" id="role" name="role">
                        <option value="admin" <?= $role === 'admin' ? 'selected' : '' ?>>Admin</option>
                        <option value="user" <?= $role === 'user' ? 'selected' : '' ?>>Usuário</option>
                    </select>
                    <span class="text-danger"><?= $roleErr ?></span>
                </div>

                <div class="mb-3">
                    <label for="expires_at" class="form-label">Data de Expiração</label>
                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at" value="">
                    <span class="text-danger"><?= $expiresAtErr ?></span>
                </div>

                <button type="submit" class="btn btn-primary w-100">Criar Usuário</button>
                <a href="admin_users.php" class="btn btn-secondary w-100 btn-back">Voltar</a>
            </form>
        </div>
    </div>

</body>
</html>
