<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user'] !== 'admin') {
    header("Location: login.php");
    exit;
}

require_once 'conexao.php';

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

try {
    $db = getDB();

    // Buscar o usuário antes de excluir
    $stmt = $db->prepare("SELECT username FROM users WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        die("Usuário não encontrado.");
    }

    if ($user['username'] === 'admin') {
        die("Você não pode excluir o administrador.");
    }

    // Excluir do banco
    $delete = $db->prepare("DELETE FROM users WHERE id = :id");
    $delete->execute([':id' => $id]);

    // Excluir diretório do usuário
    $uploadDir = "uploads/" . $user['username'];
    if (is_dir($uploadDir)) {
        array_map('unlink', glob("$uploadDir/*"));
        rmdir($uploadDir);
    }

    header("Location: admin_users.php");
    exit;
} catch (PDOException $e) {
    die("Erro ao excluir usuário: " . $e->getMessage());
}
