<?php
session_start(); // Iniciar a sessão

// Verificar se o usuário está logado
if (!isset($_SESSION['user'])) {
    header("Location: login.php"); // Redirecionar para login.php caso não esteja logado
    exit; // Encerra o script para garantir que o código abaixo não seja executado
}

$tmdb_api_key = "8a3649eeb7769825cdb5d58fc89af059";
$type = $_GET['type'] ?? 'movie';  // Tipo de conteúdo (movie ou tv)
$cat = $_GET['cat'] ?? 'popular';  // Categoria (popular, top_rated, etc.)
$search = $_GET['search'] ?? null;  // Busca por nome

// A URL da API depende do tipo e da categoria
if ($search) {
  $url = "https://api.themoviedb.org/3/search/{$type}?query=" . urlencode($search) . "&api_key={$tmdb_api_key}&language=pt-BR";
} else {
  $url = "https://api.themoviedb.org/3/{$type}/{$cat}?api_key={$tmdb_api_key}&language=pt-BR";
}

$data = json_decode(file_get_contents($url), true);

// Verifica se o logo foi carregado
$logoExists = file_exists("uploads/{$_SESSION['user']}/logo.png");
$logoPath = $logoExists ? "uploads/{$_SESSION['user']}/logo.png" : '';  // Caminho da logo
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>TMDB - Gerador de Banners</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    /* Vídeo de fundo */
    body, html {
      height: 100%;
      margin: 0;
      padding: 0;
      position: relative;
    }

    video.background-video {
      position: fixed; /* Fixar o vídeo para que fique no fundo enquanto rola a página */
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      z-index: -1; /* Coloca o vídeo atrás do conteúdo */
    }

    /* Estilo do conteúdo */
    .container {
      max-width: 1200px;
      padding-left: 50px;
      padding-right: 50px;
      z-index: 1; /* Garante que o conteúdo fique na frente do vídeo */
    }

    /* Estilo dos botões */
    .btn {
      font-size: 16px;
      padding: 12px 24px;
      border-radius: 30px;
      transition: background-color 0.3s ease, transform 0.2s ease;
    }

    .btn-primary {
      background-color: #ff7e5f;
      border: none;
    }

    .btn-primary:hover {
      background-color: #feb47b;
      transform: scale(1.05);
    }

    .btn-info {
      background-color: #28a745;
      border: none;
    }

    .btn-info:hover {
      background-color: #218838;
    }

    .btn-secondary {
      background-color: #333;
      border: none;
    }

    .btn-secondary:hover {
      background-color: #444;
    }

    .btn-danger {
      background-color: #dc3545;
      border: none;
    }

    .btn-danger:hover {
      background-color: #c82333;
    }

    /* Estilo dos cards */
    .card {
      background: #111;
      border: none;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.5);
      margin-bottom: 15px;
      transition: transform 0.3s ease;
    }

    .card:hover {
      transform: scale(1.05);
    }

    .card-title {
      font-size: 0.9rem;
      color: #ffc107;
      font-weight: bold;
      margin-bottom: 10px;
    }

    .card img {
      width: 100%;
      height: 250px;
      object-fit: cover;
    }

    .card-body {
      padding: 15px;
      text-align: center;
      height: 150px;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }

    /* Campo de busca */
    .search-bar {
      margin-bottom: 30px;
      display: flex;
      justify-content: space-between;
      gap: 10px;
      align-items: center;
      flex-wrap: wrap;
    }

    /* Logo e mensagem */
    .logo-message {
      font-size: 0.9rem;
    }

    .btn-gerar-banner {
      padding: 10px 20px;
      font-size: 0.8rem;
      background-color: #ffc107;
      border: none;
      border-radius: 30px;
      color: black;
      transition: background-color 0.3s ease, transform 0.2s ease-in-out;
    }

    .btn-gerar-banner:hover {
      background-color: #e0a800;
      transform: scale(1.05);
    }

    /* Estilos de categorias */
    .btn-group {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin-bottom: 20px;
    }

    .btn-group .btn {
      padding: 10px 20px;
      font-size: 14px;
      border-radius: 30px;
    }

    /* Responsividade */
    @media (max-width: 768px) {
      .container {
        padding: 20px;
      }

      .card {
        max-width: 100%;
      }

      .btn-gerar-banner {
        padding: 5px 10px;
        font-size: 0.7rem;
      }

      .search-bar {
        flex-direction: column;
        gap: 20px;
      }

      .search-bar .form-control {
        width: 100%;
      }
    }

    /* Cor do título em branco */
    h1 {
      color: white; /* Título em branco */
    }

  </style>
</head>
<body>
  <!-- Vídeo Plexus como fundo -->
  <video class="background-video" autoplay loop muted>
    <source src="Plexus.mp4" type="video/mp4">
    Seu navegador não suporta vídeos.
  </video>

  <div class="container py-4">
    <!-- Título e botão de Sair -->
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h1 class="text-center flex-grow-1">🎬 TMDB - Gerador de Banners</h1>
      <a href="logout.php" class="btn btn-danger">Sair</a>
    </div>

    <!-- Exibição da logo -->
    <?php if ($logoExists): ?>
      <div class="mb-3">
        <img src="<?= $logoPath ?>" alt="Logo do Usuário" class="img-fluid" style="max-width: 50px;">
        <p class="text-success logo-message">Sua logo já foi adicionada!</p>
      </div>
    <?php else: ?>
      <p class="text-warning">⚠️ Envie sua logo para gerar o banner.</p>
    <?php endif; ?>

    <!-- Botão de painel administrativo (só para admin) -->
    <?php if ($_SESSION['role'] === 'admin'): ?>
      <div class="mb-3">
        <a href="painel.php" class="btn btn-success">🛠️ Painel Administrativo</a>
      </div>
    <?php endif; ?>

    <!-- Formulário de busca -->
    <form class="search-bar" method="GET" action="">
      <div class="d-flex justify-content-center align-items-center gap-3">
        <!-- Botão para upload da logo -->
        <a href="upload_logo.php" class="btn btn-info">Sua Logo</a>

        <!-- Botões de tipo (Filmes/Séries) -->
        <div class="btn-group" role="group">
          <a href="?type=movie&cat=<?= $cat ?>" class="btn btn-outline-light <?= $type == 'movie' ? 'active' : '' ?>">🎥 Filmes</a>
          <a href="?type=tv&cat=<?= $cat ?>" class="btn btn-outline-light <?= $type == 'tv' ? 'active' : '' ?>">📺 Séries</a>
        </div>

        <!-- Campo de busca -->
        <input type="text" name="search" class="form-control" style="width: 250px;" placeholder="Buscar por nome..." required>

        <!-- Botão de buscar -->
        <button class="btn btn-primary">Buscar</button>
      </div>
    </form>

    <!-- Categorias -->
    <div class="d-flex justify-content-between mb-4">
      <a href="?cat=upcoming&type=<?= $type ?>" class="btn btn-dark">🆕 Lançamentos</a>
      <a href="?cat=popular&type=<?= $type ?>" class="btn btn-dark">🔥 Populares</a>
      <a href="?cat=top_rated&type=<?= $type ?>" class="btn btn-dark">⭐ Melhor Avaliados</a>
      <a href="?cat=now_playing&type=<?= $type ?>" class="btn btn-dark">🎞️ Em Cartaz</a>
      <a href="?cat=airing_today&type=tv" class="btn btn-dark">📺 Hoje na TV</a>
    </div>

    <!-- Exibição dos filmes/séries -->
    <div class="row">
      <?php foreach ($data['results'] ?? [] as $item): 
        $title = $item['title'] ?? $item['name'];
        $poster = $item['poster_path'] ? "https://image.tmdb.org/t/p/w500{$item['poster_path']}" : '';
        $id = $item['id'];
      ?>
        <div class="col-md-2 mb-3">
          <div class="card">
            <img src="<?= $poster ?: 'default-poster.jpg' ?>" class="card-img-top" alt="<?= htmlspecialchars($title) ?>">

            <!-- Só exibe o botão "Gerar Banner" após o upload do logo -->
            <?php if ($logoExists): ?>
              <a href="generate_banner.php?id=<?= $id ?>&type=<?= $type ?>" class="btn btn-sm btn-warning btn-gerar-banner">🎨 Gerar Banner</a>
            <?php else: ?>
              <span class="text-warning small">⚠️ Envie sua logo</span>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</body>
</html>
