<?php
session_start();
$tmdb_api_key = "8a3649eeb7769825cdb5d58fc89af059";
$query = urlencode($_GET['q'] ?? '');
if (!$query) exit;

$results = [];
foreach (['movie', 'tv'] as $type) {
    $url = "https://api.themoviedb.org/3/search/$type?api_key=$tmdb_api_key&language=pt-BR&query=$query";
    $json = json_decode(file_get_contents($url), true);
    if (!empty($json['results'])) {
        foreach ($json['results'] as $item) {
            $item['type'] = $type;
            $results[] = $item;
        }
    }
}

usort($results, fn($a, $b) => ($b['popularity'] ?? 0) <=> ($a['popularity'] ?? 0));

foreach ($results as $r):
    $poster = $r['poster_path'] ? "https://image.tmdb.org/t/p/w300" . $r['poster_path'] : '';
    $title = $r['title'] ?? $r['name'];
    $id = $r['id'];
    $type = $r['type'];
?>
<div class="col-md-3">
    <div class="card bg-dark text-white h-100">
        <?php if ($poster): ?>
            <img src="<?= $poster ?>" class="card-img-top" alt="<?= htmlspecialchars($title) ?>">
        <?php endif; ?>
        <div class="card-body d-flex flex-column">
            <h5 class="card-title"><?= htmlspecialchars($title) ?></h5>
            <p class="card-text"><?= strtoupper($type) ?></p>
            <?php if (isset($_SESSION['logo_ok'])): ?>
                <a href="generate_banner.php?id=<?= $id ?>&type=<?= $type ?>" class="btn btn-primary mt-auto">🎨 Gerar Banner</a>
            <?php else: ?>
                <p class="text-warning">Envie a logo primeiro</p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endforeach; ?>
