<?php
session_start(); // Iniciar a sessão

// Verificar se o usuário está logado e tem o papel de admin
if (!isset($_SESSION['user']) || $_SESSION['role'] !== 'admin') {
    // Se não estiver logado ou não for admin, redireciona para login.php
    header("Location: login.php");
    exit;
}

try {
    $db = new PDO("sqlite:database.db");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Consultar todos os usuários do banco de dados
    $stmt = $db->query("SELECT id, username, role, expires_at FROM users ORDER BY username ASC");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro ao acessar o banco de dados: " . $e->getMessage());
}

// Verificar se o id de exclusão foi passado pela URL
if (isset($_GET['delete_id'])) {
    $deleteId = $_GET['delete_id'];

    // Verificar se o usuário a ser excluído não é o admin
    if ($deleteId !== '1') { // Supondo que o id do admin seja '1'
        $stmt = $db->prepare("DELETE FROM users WHERE id = ?");
        $stmt->execute([$deleteId]);
    }
    header("Location: admin_users.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Gerenciar Usuários</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    /* Vídeo de fundo */
    body, html {
      height: 100%;
      margin: 0;
      padding: 0;
      position: relative;
    }

    video.background-video {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      z-index: -1;
    }

    /* Estilo do conteúdo */
    .container {
      max-width: 1200px;
      padding-left: 30px;
      padding-right: 30px;
      z-index: 1;
    }

    /* Botões principais */
    .btn {
      font-size: 14px;
      padding: 8px 20px;
      border-radius: 25px;
      transition: background-color 0.3s ease, transform 0.2s ease;
    }

    .btn-primary {
      background-color: #ff7e5f;
      border: none;
    }

    .btn-primary:hover {
      background-color: #feb47b;
      transform: scale(1.05);
    }

    .btn-info {
      background-color: #28a745;
      border: none;
    }

    .btn-info:hover {
      background-color: #218838;
    }

    .btn-secondary {
      background-color: #333;
      border: none;
    }

    .btn-secondary:hover {
      background-color: #444;
    }

    .btn-danger {
      background-color: #dc3545;
      border: none;
    }

    .btn-danger:hover {
      background-color: #c82333;
    }

    h2 {
      color: white; /* Título em branco */
      font-size: 1.8rem;
      text-align: center;
    }

    .table {
      font-size: 0.85rem; /* Reduzir o tamanho da fonte da tabela */
    }

    .form-select, .form-control {
      background: #333;
      color: white;
      border: none;
      border-radius: 12px;
    }

    /* Ajustes para botões de ações */
    .table td, .table th {
      padding: 3px 8px; /* Reduzir o padding das células da tabela */
    }

    /* Compactando os botões dentro da tabela */
    .table .btn {
      font-size: 10px; /* Tamanho da fonte menor */
      padding: 4px 8px; /* Padding reduzido */
      border-radius: 18px; /* Borda mais arredondada */
    }

    /* Responsividade */
    @media (max-width: 768px) {
      .container {
        padding: 20px;
      }

      .card {
        max-width: 100%;
      }
    }

  </style>
</head>
<body>
  <!-- Vídeo Plexus como fundo -->
  <video class="background-video" autoplay loop muted>
    <source src="Plexus.mp4" type="video/mp4">
    Seu navegador não suporta vídeos.
  </video>

  <div class="container py-5">
    <h2 class="mb-4">👥 Lista de Usuários</h2>

    <div class="mb-3 text-end">
      <a href="create_user.php" class="btn btn-success">➕ Novo Usuário</a>
      <a href="painel.php" class="btn btn-secondary">⬅️ Voltar ao Painel</a>
    </div>

    <?php if (empty($users)): ?>
      <div class="alert alert-warning text-center">Nenhum usuário cadastrado.</div>
    <?php else: ?>
      <table class="table table-bordered table-striped">
        <thead class="table-dark">
          <tr>
            <th>Usuário</th>
            <th>Papel</th>
            <th>Data de Expiração</th>
            <th>Ações</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user): ?>
          <tr>
            <td><?= htmlspecialchars($user['username']) ?></td>
            <td><?= htmlspecialchars($user['role'] ?? 'user') ?></td>
            <td><?= htmlspecialchars($user['expires_at']) ?></td>
            <td>
              <a href="edit_user.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-primary">✏️ Editar</a>
              <?php if ($user['username'] !== 'admin'): ?>
                <a href="?delete_id=<?= $user['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja excluir este usuário?')">🗑️ Excluir</a>
              <?php else: ?>
                <span class="text-muted">Administrador</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>

  <!-- Modal de Renovação (REMOVIDO) -->
  <!-- O modal de renovação foi removido, pois não será mais necessário -->

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
