<?php
session_start(); // Iniciar a sessão

// Verificar se o usuário está logado e tem o papel de admin
if (!isset($_SESSION['user']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

try {
    $db = new PDO("sqlite:database.db");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_GET['id'])) {
        $userId = $_GET['id'];
        // Consultar os dados do usuário
        $stmt = $db->prepare("SELECT * FROM users WHERE id = :id");
        $stmt->execute([':id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $username = $_POST['username'];
        $role = $_POST['role'];
        // Verifica se a senha foi preenchida, se sim, atualiza a senha, caso contrário, mantém a senha existente
        $password = $_POST['password'] ? password_hash($_POST['password'], PASSWORD_DEFAULT) : $user['password'];
        $expires_at = $_POST['expires_at'];

        // Atualizar o usuário no banco de dados
        $stmt = $db->prepare("UPDATE users SET username = :username, role = :role, password = :password, expires_at = :expires_at WHERE id = :id");
        $stmt->execute([
            ':username' => $username,
            ':role' => $role,
            ':password' => $password,
            ':expires_at' => $expires_at,
            ':id' => $userId
        ]);

        header("Location: admin_users.php");
        exit;
    }
} catch (PDOException $e) {
    die("Erro ao acessar o banco de dados: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Editar Usuário</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    /* Vídeo de fundo */
    body, html {
      height: 100%;
      margin: 0;
      padding: 0;
      position: relative;
      font-family: Arial, sans-serif;
    }

    video.background-video {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      z-index: -1;
    }

    /* Estilo do conteúdo */
    .container {
      max-width: 400px;
      padding: 15px;
      background-color: rgba(0, 0, 0, 0.6); /* Fundo escuro para contraste */
      border-radius: 10px;
      color: white;
    }

    /* Reduzindo os botões */
    .btn {
      font-size: 12px;
      padding: 6px 12px;
      border-radius: 20px;
    }

    .btn-primary {
      background-color: #ff7e5f;
      border: none;
    }

    .btn-primary:hover {
      background-color: #feb47b;
      transform: scale(1.05);
    }

    .btn-secondary {
      background-color: #333;
      border: none;
    }

    .btn-secondary:hover {
      background-color: #444;
    }

    h2 {
      font-size: 1.4rem;
      text-align: center;
    }

    .form-group {
      margin-bottom: 15px;
    }

    .form-control {
      background-color: #444;
      color: white;
      border: none;
      border-radius: 10px;
      padding: 8px;
    }

    .form-label {
      font-size: 0.9rem;
      color: white;
    }

    /* Ajustes no campo de data */
    input[type="datetime-local"] {
      width: 100%;
      padding: 8px;
      font-size: 1rem;
      background-color: #444;
      color: white;
      border: none;
      border-radius: 10px;
    }

    /* Responsividade */
    @media (max-width: 768px) {
      .container {
        padding: 10px;
      }
    }

  </style>
</head>
<body>

  <!-- Vídeo Plexus como fundo -->
  <video class="background-video" autoplay loop muted>
    <source src="Plexus.mp4" type="video/mp4">
    Seu navegador não suporta vídeos.
  </video>

  <div class="container py-3">
    <h2>Editar Usuário</h2>

    <form method="POST">
      <!-- Nome de Usuário -->
      <div class="form-group mb-3">
        <label for="username" class="form-label">Nome de Usuário</label>
        <input type="text" class="form-control" name="username" id="username" value="<?= htmlspecialchars($user['username']) ?>" required>
      </div>

      <!-- Papel do Usuário -->
      <div class="form-group mb-3">
        <label for="role" class="form-label">Papel</label>
        <select name="role" id="role" class="form-control" required>
          <option value="user" <?= $user['role'] == 'user' ? 'selected' : '' ?>>Usuário</option>
          <option value="admin" <?= $user['role'] == 'admin' ? 'selected' : '' ?>>Administrador</option>
        </select>
      </div>

      <!-- Senha (opcional) -->
      <div class="form-group mb-3">
        <label for="password" class="form-label">Nova Senha (deixe em branco para não alterar)</label>
        <input type="password" class="form-control" name="password" id="password">
      </div>

      <!-- Data de Expiração -->
      <div class="form-group mb-3">
        <label for="expires_at" class="form-label">Nova Data de Expiração</label>
        <input type="datetime-local" class="form-control" name="expires_at" id="expires_at" value="<?= htmlspecialchars($user['expires_at']) ?>" required>
      </div>

      <button type="submit" class="btn btn-primary w-100 mb-2">Salvar alterações</button>
      <a href="admin_users.php" class="btn btn-secondary w-100">Voltar</a>
    </form>
  </div>

</body>
</html>
