<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$tmdb_api_key = "8a3649eeb7769825cdb5d58fc89af059";
if (!isset($_GET['id']) || !isset($_GET['type'])) die("Parâmetros ausentes.");

$id = intval($_GET['id']);
$type = $_GET['type'] === 'tv' ? 'tv' : 'movie';
$url = "https://api.themoviedb.org/3/$type/$id?language=pt-BR&api_key=$tmdb_api_key";
$data = json_decode(file_get_contents($url), true);

$title = $data['title'] ?? $data['name'] ?? 'Sem Título';
$poster_url = "https://image.tmdb.org/t/p/w780" . $data['poster_path'];
$desc = $data['overview'] ?? 'Sinopse não disponível.';
$title_wrapped = wordwrap($title, 30, "\n", true);

// **Obter valores das seleções (se existirem)**
$selected_text_color = $_GET['text_color'] ?? 'yellow';
$footer_opacity = isset($_GET['footer_opacity']) ? intval($_GET['footer_opacity']) : 40; // Definindo opacidade 70 para o rodapé
$footer_opacity = max(0, min(127, $footer_opacity)); // Garante que o valor da opacidade esteja no intervalo de 0 a 127

// Criando a imagem base (deve ser feita antes de alocar as cores)
$width = 800;
$height = 1280;
$banner = imagecreatetruecolor($width, $height);
if (!$banner) {
    die("Erro ao criar a imagem.");
}

// Definir a cor de fundo do rodapé com um tom mais escuro
$footer_color = imagecolorallocatealpha($banner, 0, 0, 0, $footer_opacity); // Preto, com opacidade ajustável

// **Alocar as cores para o texto**
switch ($selected_text_color) {
    case 'white':
        $text_color = imagecolorallocate($banner, 255, 255, 255); // Branco
        break;
    case 'red':
        $text_color = imagecolorallocate($banner, 255, 0, 0); // Vermelho
        break;
    case 'yellow':
    default:
        $text_color = imagecolorallocate($banner, 255, 255, 0); // Amarelo
        break;
}

// Baixar o poster da API
$poster = @imagecreatefromjpeg($poster_url);
if (!$poster) {
    die("Erro ao carregar a imagem do poster.");
}
imagecopyresampled($banner, $poster, 0, 0, 0, 0, $width, $height, imagesx($poster), imagesy($poster));

// Moldura moderna com linhas externas transparentes
$frame_thickness = 20;
$border_color = imagecolorallocatealpha($banner, 255, 215, 0, 60); // Dourado semi-transparente
for ($i = 0; $i < $frame_thickness; $i++) {
    imagerectangle($banner, $i, $i, $width - 1 - $i, $height - 1 - $i, $border_color);
}

// Rodapé escuro dentro da moldura
$footer_h = 360;
$padding = $frame_thickness;
imagefilledrectangle(
    $banner,
    $padding,
    $height - $footer_h - $padding,
    $width - $padding,
    $height - $padding,
    $footer_color
);

// Fonte e cor
$font = __DIR__ . "/assets/Roboto-Regular.ttf";

// Centralizar o título
$title_box = imagettfbbox(60, 0, $font, $title_wrapped);
$title_width = $title_box[2] - $title_box[0];
$title_x = ($width - $title_width) / 2;
imagettftext($banner, 60, 0, $title_x, $height - $footer_h - $padding + 60, $text_color, $font, $title_wrapped);

// Posicionar e ajustar a sinopse dinamicamente
$y = $height - $footer_h - $padding + 140;
$max_footer_height = $height - $padding - $y - 20;
$line_height = 38;
$max_lines = floor($max_footer_height / $line_height);

// Quebra de palavras respeitando largura
$wrapped_lines = [];
$words = explode(' ', $desc);
$current_line = '';

foreach ($words as $word) {
    $test_line = trim($current_line . ' ' . $word);
    $line_box = imagettfbbox(32, 0, $font, $test_line);
    $line_width = $line_box[2] - $line_box[0];

    if ($line_width < $width - 80) {
        $current_line = $test_line;
    } else {
        $wrapped_lines[] = $current_line;
        $current_line = $word;
        if (count($wrapped_lines) >= $max_lines) break;
    }
}
if (!empty($current_line) && count($wrapped_lines) < $max_lines) {
    $wrapped_lines[] = $current_line;
}

if (count($wrapped_lines) >= $max_lines && !empty($current_line)) {
    $wrapped_lines[count($wrapped_lines) - 1] = rtrim($wrapped_lines[count($wrapped_lines) - 1], '.') . '...';
}

foreach ($wrapped_lines as $line) {
    $line_box = imagettfbbox(32, 0, $font, $line);
    $line_width = $line_box[2] - $line_box[0];
    $line_x = ($width - $line_width) / 2;
    imagettftext($banner, 32, 0, $line_x, $y, $text_color, $font, $line);
    $y += $line_height;
}

// Inserir logo do usuário
$username = preg_replace('/[^a-z0-9_]/i', '', $_SESSION['user']);
$logo_path = "uploads/$username/logo.png";
if (file_exists($logo_path)) {
    $logo_img = @imagecreatefrompng($logo_path);
    if ($logo_img) {
        $logo_w = 180;
        $logo_h = 80;
        imagecopyresampled($banner, $logo_img, 30, 30, 0, 0, $logo_w, $logo_h, imagesx($logo_img), imagesy($logo_img));
    }
}

if (!is_dir("banners")) mkdir("banners");
$output = "banners/banner_" . uniqid() . ".png";
imagepng($banner, $output);
imagedestroy($banner);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Banner Gerado</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body, html {
      height: 100%;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      background-color: #000;
    }

    video.background-video {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      z-index: -1;
    }

    .container {
      text-align: center;
      z-index: 1;
      max-width: 1200px;
      padding: 20px;
      background-color: rgba(0, 0, 0, 0.7);
      border-radius: 10px;
    }

    .banner-img {
      max-height: 500px;
      width: auto;
      border-radius: 10px;
      box-shadow: 0 0 20px #000;
      margin: 20px auto;
      display: block;
    }

    h1, h2 {
      color: white;
    }

    .btn {
      margin-top: 20px;
    }
  </style>
</head>
<body>
  <video class="background-video" autoplay loop muted>
    <source src="Plexus.mp4" type="video/mp4">
    Seu navegador não suporta vídeos.
  </video>

  <div class="container py-4">
    <h2 class="mb-2">✅ Banner Gerado</h2>
    <img src="<?= $output ?>" class="banner-img">
    
    <div class="mt-4">
      <a href="<?= $output ?>" download class="btn btn-success">📥 Baixar</a>
      <a href="index.php" class="btn btn-secondary">🔙 Voltar</a>
    </div>
  </div>
</body>
</html>
