<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php"); // Redireciona para login.php caso o usuário não seja admin
    exit; // Encerra o script para garantir que o código abaixo não seja executado
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Painel Administrativo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    /* Vídeo de fundo */
    body, html {
      height: 100%;
      margin: 0;
      padding: 0;
      position: relative;
    }

    video.background-video {
      position: fixed; /* Fixar o vídeo para que fique no fundo enquanto rola a página */
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      z-index: -1; /* Coloca o vídeo atrás do conteúdo */
    }

    /* Estilo do conteúdo */
    .container {
      max-width: 1200px;
      padding-left: 50px;
      padding-right: 50px;
      z-index: 1; /* Garante que o conteúdo fique na frente do vídeo */
    }

    .btn {
      font-size: 16px;
      padding: 12px 24px;
      border-radius: 30px;
      transition: background-color 0.3s ease, transform 0.2s ease;
    }

    .btn-primary {
      background-color: #ff7e5f;
      border: none;
    }

    .btn-primary:hover {
      background-color: #feb47b;
      transform: scale(1.05);
    }

    /* Responsividade */
    @media (max-width: 768px) {
      .container {
        padding: 20px;
      }
    }

    /* Cor do título em branco */
    h2 {
      color: white; /* Título em branco */
    }

  </style>
</head>
<body>
  <!-- Vídeo Plexus como fundo -->
  <video class="background-video" autoplay loop muted>
    <source src="Plexus.mp4" type="video/mp4">
    Seu navegador não suporta vídeos.
  </video>

  <div class="container py-5">
    <h2 class="mb-4 text-center">🛠️ Painel Administrativo</h2>

    <div class="d-flex justify-content-center gap-3">
      <!-- Botões de navegação para as ações administrativas -->
      <a href="admin_users.php" class="btn btn-primary">👥 Gerenciar Usuários</a>
      <a href="create_user.php" class="btn btn-success">➕ Criar Novo Usuário</a>
      <a href="index.php" class="btn btn-secondary">🎬 Ir para o Gerador de Banners</a>

      <!-- Botão de logout -->
      <a href="logout.php" class="btn btn-danger">Sair</a>
    </div>
  </div>
</body>
</html>
