<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$user = preg_replace('/[^a-z0-9_]/i', '', $_SESSION['user']);
$user_dir = "uploads/$user";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    if (!is_dir($user_dir)) mkdir($user_dir, 0777, true);
    move_uploaded_file($_FILES['logo']['tmp_name'], "$user_dir/logo.png");
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Upload de Logo Pessoal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white p-4">
  <h2>📤 Enviar Logo Pessoal</h2>
  <form method="POST" enctype="multipart/form-data">
    <input type="file" name="logo" accept="image/png" class="form-control mb-3" required>
    <button class="btn btn-success">Enviar</button>
    <a href="index.php" class="btn btn-secondary">Voltar</a>
  </form>
</body>
</html>
